/******************************************************************************/
/**	\file	adc.h
 *
 *	\brief	This file provides all the APIs provided by QADC64E module 
 *			of Freescale MPC563 power-pc MCU
 *
 *	\version	1.0A - Initial Draft
 *	\date		25 June 2010
 *
 *	\version	1.1A - Design changed to support run-time CCW addition and 
 *						configuration
 *	\date		16 July 2010
 ******************************************************************************/
#ifndef ADC_H
#define ADC_H
/******************************************************************************
Include Files
******************************************************************************/

 
 
/**	\typedef	QADC_Module_ID
 *	\brief		This typedefine enum provides the ADC conversion modules */
 typedef enum
 {
	/**	\brief	This is channel-A ADC converter */
	ADC_MOD_A,
	/** \brief	This is channel-B ADC converter */
	ADC_MOD_B,
	/**	\brief	Defines the total no of ADC converters supported */
	ADC_TOT_MOD
 }QADC_Module_ID;
 
/**	\typedef	QADC_Drv_Status
 *	\brief		This enum typedefine provides various status of ADC driver 
				module */ 
 typedef enum
 {
	/**	This indicates that driver is not initialized */
	ADC_DRV_UNINIT,
	/**	This indicates that driver is initialized but not ready for conversion */
	ADC_DRV_INIT,
	/**	This indicates that ADC converter module is ready for conversion */
	ADC_DRV_ACTIVE,
	/** Unknown ADC converter state */
	ADC_UNKNOWN_STATE,
 }QADC_Drv_Status;

/**	\typedef	QADC_DrvOpStatus
 *	\brief		This enum typedefine provides various operation states 
				if the ADC driver */ 
typedef enum
{
	/** Driver operation failed due to unknwon reason */
	ADC_OP_FAIL,
	/** Driver operation success */
	ADC_OP_SUCCESS,
	/** Driver operation failed due to invalid ADC converter module ID */
	ADC_OP_INVALID_MOD_ID,
	/** Driver operation failed due to invalid CCW ID */
	ADC_OP_INVALID_CCW_ID,
	/** Driver operation failed due to invalid user provided data */
	ADC_OP_INVALID_DATA,
	/** Driver operation failed as the current state of driver does not support the requested action */
	ADC_OP_UNSUPP_STATE,
	/** Read operation failed, as the read format provided is not supported */
	ADC_OP_UNSUPP_RD_FMT,
}QADC_DrvOpStatus;;

/**	\typedef	QADC_ConvMod_CCWs
 *	\brief		This enum typedefine provides all the CCW IDs 
				registered for both ADC converter module A and B */ 
 typedef enum 
 {
	/* ADC converter module CCWs */
	ADC_MOD_CCW_0,
	ADC_MOD_CCW_1,
	ADC_MOD_CCW_2,
	ADC_MOD_CCW_3,
	ADC_MOD_CCW_4,
	ADC_MOD_CCW_5,
	ADC_MOD_CCW_6,
	ADC_MOD_CCW_7,
	ADC_MOD_CCW_8,
	ADC_MOD_CCW_9,
	ADC_MOD_CCW_10,
	ADC_MOD_CCW_11,
	ADC_MOD_CCW_12,
	ADC_MOD_CCW_13,
	ADC_MOD_CCW_14,
	ADC_MOD_CCW_15,
	ADC_MOD_CCW_16,
	ADC_MOD_CCW_17,
	ADC_MOD_CCW_18,
	ADC_MOD_CCW_19,
	ADC_MOD_CCW_20,
	ADC_MOD_CCW_21,
	ADC_MOD_CCW_22,
	ADC_MOD_CCW_23,
	ADC_MOD_CCW_24,
	ADC_MOD_CCW_25,
	ADC_MOD_CCW_26,
	ADC_MOD_CCW_27,
	ADC_MOD_CCW_28,
	ADC_MOD_CCW_29,
	ADC_MOD_CCW_30,
	ADC_MOD_CCW_31,
	ADC_MOD_CCW_32,
	ADC_MOD_CCW_33,
	ADC_MOD_CCW_34,
	ADC_MOD_CCW_35,
	ADC_MOD_CCW_36,
	ADC_MOD_CCW_37,
	ADC_MOD_CCW_38,
	ADC_MOD_CCW_39,
	ADC_MOD_CCW_40,
	ADC_MOD_CCW_41,
	ADC_MOD_CCW_42,
	ADC_MOD_CCW_43,
	ADC_MOD_CCW_44,
	ADC_MOD_CCW_45,
	ADC_MOD_CCW_46,
	ADC_MOD_CCW_47,
	ADC_MOD_CCW_48,
	ADC_MOD_CCW_49,
	ADC_MOD_CCW_50,
	ADC_MOD_CCW_51,
	ADC_MOD_CCW_52,
	ADC_MOD_CCW_53,
	ADC_MOD_CCW_54,
	ADC_MOD_CCW_55,
	ADC_MOD_CCW_56,
	ADC_MOD_CCW_57,
	ADC_MOD_CCW_58,
	ADC_MOD_CCW_59,
	ADC_MOD_CCW_60,
	ADC_MOD_CCW_61,
	ADC_MOD_CCW_62,
	ADC_MOD_CCW_63,
	ADC_MOD_CCW_TOT,
 }QADC_ConvMod_CCWs;

struct QADC64_tag 
{
		union 
	{
		VUINT16 R;
		struct 
		{
			VUINT16 STOP:1;
			VUINT16 FRZ:1;
			VUINT16:4;
			VUINT16 LOCK:1;
			VUINT16 FLIP:1;
			VUINT16 SUPV:1;
			VUINT16:7;
		}B;
	}QADC64MCR;

};
#endif